# ENST/YM2005 Precision Synthesis TCL script
###############################################################################
# Get environnement variables
###############################################################################
set enst_prefix $env(enst_prefix)
set enst_top_module $env(enst_top_module)
set enst_top_verilog_src $env(enst_top_verilog_src)
set enst_work_dir [file normalize $env(enst_work_dir)]
set enst_script_file [file normalize $env(enst_script_file)]
set enst_src_file [file normalize $env(enst_src_file)]
set enst_pads_file [file normalize $env(enst_pads_file)]
set enst_timings_file [file normalize $env(enst_timings_file)]
set enst_results_dir [file normalize $env(enst_results_dir)]
puts $enst_top_verilog_src
###############################################################################
# Verifications 
###############################################################################
if { ![file exists $enst_work_dir] } {
  error "ENST : No working directory  $enst_work_dir"
}
if { ![file exists $enst_script_file] } {
  error "ENST : No  script file $enst_script_file"
}
if { ![file exists $enst_pads_file] } {
  error "ENST : No  pads file $enst_pads_file"
}
if { ![file exists $enst_src_file] } {
  error "ENST : No  src file $enst_src_file"
}
if { ![file exists $enst_timings_file] } {
  error "ENST : No  pads file $enst_timings_file"
}

###############################################################################
# Define the results directory
###############################################################################
# Setup the project

if { [file exists $enst_results_dir] } {
  # Allready exist : clean up
  if { [catch {file delete -force -- $enst_results_dir} fid] } {
    error "ENST : Unable to delete $enst_results_dir diectory"
  }
} 
# Create it
if { [catch {file mkdir $enst_results_dir} fid] } {
    error "ENST : Unable to create $enst_results_dir diectory"
}
new_project -name $enst_prefix -folder $enst_results_dir -createimpl -createimpl_name ${enst_prefix}_impl


###############################################################################
# General design setup
###############################################################################
puts "###############################################################################"
puts "# ENST : General design setup"
puts "###############################################################################"

# The chip..
setup_design -manufacturer Xilinx -family SPARTAN2E -part 2s300eft256 -speed 6

# Uncomment for a  macro (not a true chip)
#setup_design -addio=false

# General optimization options
setup_design -compile_for_area
setup_design -resource_sharing=true
#setup_design -retimings

# Timing specs
#setup_design -frequency 80 -input_delay 4 -output_delay 4

# The top level
setup_design -design $enst_top_module

###############################################################################
# Read the source files
###############################################################################
puts "###############################################################################"
puts "# ENST : Definition of  the source files..."

dofile $enst_src_file

puts "# ENST : ok"
puts "###############################################################################"

###############################################################################
# Compile the sources
###############################################################################
puts "###############################################################################"
puts "# ENST : Compiling the sources"
puts "###############################################################################"
compile

###############################################################################
# Set constraints at RTL level
###############################################################################
puts "###############################################################################"
puts "# ENST : Setting constraints at RTL level..."
puts "# ENST : dofile $enst_pads_file"
dofile $enst_pads_file
puts "# ENST : dofile $enst_timings_file"
#dofile $enst_timings_file
puts "# ENST : End"
puts "###############################################################################"

###############################################################################
# Synthesize the chip with constraints
###############################################################################
puts "###############################################################################"
puts "# ENST : Synthesizing the chip with constraints"
puts "###############################################################################"
synthesize

###############################################################################
#  Launch Xilinx Place and Route
###############################################################################
#puts "###############################################################################"
#puts "# ENST : Starting Xilinx pnr"
#puts "###############################################################################"
setup_place_and_route -flow {ISE 7.1} -command {Integrated Place and Route} -bits 1
place_and_route

###############################################################################
# Close the results directory and exit
###############################################################################
save_impl
puts "###############################################################################"
puts "# implementation ok"
puts "###############################################################################"
close_results_dir
