#ifndef FIR_H
#define FIR_H

// The number of tasks (function calls) 
#define L 5

// The width of the filtering windows
#define N 31

// The number of samples per function call
#define M 256

extern void fir(void);
extern char task_num;

// Define the sampling frequency
#define SFREQ (2048)

// Define the starting input frequency for the input
#define BASE_INPUT_FREQ 100

// The cut-off frequency for low-pass filter
#define FREQ1 350

extern short x[L][M];
#pragma bitsize x 13

extern short w[N];
#pragma bitsize w 11

extern short y[L][M-N];
#pragma bitsize y 13

// Fixed point representations

// Values of x are of the form x[i]*2^EXPX
#define EXPX -8
#define SIGNX   1
#define BITSIZEX 13

// Values of w are of the form w[i]*2^EXPW
#define EXPW -12
#define SIGNW   1
#define BITSIZEW  12

// Values of y are of the form y[i]*2^EXPY. 
#define EXPY -9
#define SIGNY 1
#define BITSIZEY  13

#endif
