#ifndef FIR_H
#define FIR_H

// The number of tasks (function calls) 
#define L 5

// The width of the filtering windows
#define N 31

// The number of samples per function call
#define M 256

// The output of filter1 feeds into filter2 and filter3
#define M2 (M-N)

extern void fir(void);
extern char task_num;

// Define the sampling frequency
#define SFREQ (2048)

// Define the starting input frequency for the input
#define BASE_INPUT_FREQ 100

// The cut-off frequency for these low-pass filters
#define FREQ1 350
#define FREQ2 250

extern short x[L][M];
#pragma bitsize x 13

extern short w[N];
extern short w2[N];
#pragma bitsize w 12
#pragma bitsize w2 12

extern short y2[L][M2-N];
extern short y3[L][M2-N];
#pragma bitsize y2 13
#pragma bitsize y3 13

// Fixed point representations

// Values of x are of the form x[i]*2^EXPX
#define EXPX -8
#define SIGNX   1
#define BITSIZEX 13

// Values of w are of the form w[i]*2^EXPW
#define EXPW -12
#define SIGNW   1
#define BITSIZEW  12

// Values of y are of the form y[i]*2^EXPY. 
#define EXPY -9
#define SIGNY 1
#define BITSIZEY  13

#endif
