/************************************************************************
 *                                                                      *
 * Copyright (c) 2005 Synfora, Inc.  All rights reserved.               *
 *                                                                      *
 * This file contains Confidential Information of Synfora, Inc.         *
 * In addition, certain inventions disclosed in this file may be        *
 * claimed within patents owned or patent applications filed by         *
 * Synfora or third parties.  Any use of Synfora's copyrighted works,   *
 * confidential information, patented inventions, or patent-pending     *
 * inventions is subject to the terms and conditions of your written    *
 * license agreement with Synfora, Inc.                                 *
 * All other use and disclosure is strictly prohibited.                 *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include "pico.h"
#include "example.h"

int main (int argc, char* argv[]) {
  int npaid;
  int h, i, j;

  for (i=0; i<M; i++) {
    for (j=0; j<N; j++) {
      A[i][j] = M*i+j+1;
    }
  }

  npaid = PICO_initialize_NPA (ppa);

  PICO_set_task_overlap(npaid, 2);
  for (h=0; h<L; h++) {
    output_num = h;
    x = h + 1;
    y = 2*h + 1;
    ppa ();
  }

  PICO_sync_task(npaid, 0);
  PICO_finalize_NPA (npaid);

  {
    FILE* fd = fopen("out.txt", "w");
    if (NULL == fd) {
      perror("cannot >open file out.txt");
      exit(1);
    }
    for (h=0; h<L; h++) {
      fprintf(fd, "Task %d:\n", h);
      for (i=0; i<M; i++) {
	for (j=0; j<N; j++) {
	  fprintf(fd, "%5d ", B[h][i][j]);
	}
	fprintf(fd, "\n");
      }
      fprintf(fd, "\n");
    }
  }

  return 0;
}
